

// set the dimensions and margins of the graph
var margin = { top: 60, right: 30, bottom: 40, left: 50 },
    width = 1460 - margin.left - margin.right,
    height = 450 - margin.top - margin.bottom;

// append the svg object to the body of the page
var svgTop = d3.select("#Top")
    .append("svg")
    .attr("width", width + margin.left + margin.right)
    .attr("height", height + margin.top + margin.bottom)
    .append("g")
    .attr("transform",
        "translate(" + margin.left + "," + margin.top + ")");

svgTop.append("text")
    .text("Race Distribution")
    .attr("x", 895)
    .attr("y", 8)
    .style("font-size", "1.8vh")
    .attr("font-family", "poppins")
    .attr("fill", '#4E4B4B')

// Parse the Data
d3.csv("./csvFile/ChangeTop10.csv", function (data) {

    // X axis
    var x = d3.scaleBand()
        .range([0, 800])
        .domain(data.map(function (d) { return d.Location; }))
        .padding(0.5);
    svgTop.append("g")
        .attr("transform", "translate(0,250)")
        .call(d3.axisBottom(x))
        .selectAll("text")
        .attr("transform", "translate(-10,0)rotate(-45)")
        .style("text-anchor", "end");


    // Add Y axis
    var y = d3.scaleLinear()
        .domain([0, 14])
        .range([250, 0]);
    svgTop.append("g")
    // .call(d3.axisLeft(y));

    // tooltip


    var tooltipTop = d3.select("#Top")
        .append("div")
        .attr("class", "tooltipBar")
        .style("opacity", 0)
        .style("visibility", "visible")

    // var drawCircle = svgChange.append('circle')
    //     .attr("fill", "transparent")
    //     .attr("stroke", "#FFC700")
    //     .attr("stroke-width", "2")
    //     .style("opacity", 1)
    //     .style("visibility", "visible")


    // svgTop.append('circle')
    //     .attr('cx', 800)
    //     .attr('cy', 0)
    //     .attr('r', 100)
    //     .attr('stroke', 'Green')
    //     .attr('fill', 'transparent');


    var mouseOver = function (d) {
        // for HOVER
        var remains_state = document.getElementsByClassName("State");

        for (let i = 0; i < remains_state.length; i++) {
            var state = remains_state[i];
            state.style.opacity = 0.4;
        }

        var location_name = d.Location.replace(/ /g, "_");
        var ele = document.getElementsByClassName(location_name)
        for (let i = 0; i < ele.length; i++) {
            var state = ele[i];
            state.style.opacity = 1;
        }
        //


        d3.selectAll("#myRect")
            .transition()
            .duration(200)
            .style("opacity", .5)
        d3.select(this)
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("stroke", "black")
        tooltipTop
            .transition()
            .duration(200)
            .style("opacity", 1)
        // drawCircle.style("opacity", 1)
        // .style("left", (d3.mouse(this)[0] + 800) + "px")
        // .style("top", (d3.mouse(this)[1]) + "px")
    }

    var mousemove = function (d) {
        // var state_nameChange = d.properties.name
        // var state_totalChange = d.total

        // var name = d.Location
        // var white = d.White
        // var black = d.Black
        // var other = d.Other
        // var mix = d.Mix

        // console.log(d)


        d3.selectAll("#myRect")
            .transition()
            .duration(200)
            .style("opacity", .5)
        d3.select(this)
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("stroke", "black")

        tooltipTop
            .html("<br><h1>" + "States: " + d.Location + " <br><br> </h1><h1>  "
                + "White Alone: " + d.White + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "Black Alone: "
                + d.Black + "<br><br><br><br></h1><h1>" + "Other Alone: "
                + d.Other + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "Mixed Races: " + d.Mix)
            .style("font-family", "poppins")
            .style("text-align", "left")
            .style("left", "935px")
            .style("width", "500px")
            .style("top", "60px")
            .style("font-size", "9px")
            .style("opacity", 1)
        // drawCircle
        //     .attr("cx", d.x)
        //     .attr("cy", d.y)
        //     .attr("r", d.r)
        //     .style("opacity", 1)
        // .style("left", (d3.mouse(this)[0] + 800) + "px")
        // .style("top", (d3.mouse(this)[1]) + "px")
    }

    var mouseLeave = function (d) {
        // For reverse HOVER
        var remains_state = document.getElementsByClassName("State");

        for (let i = 0; i < remains_state.length; i++) {
            var state = remains_state[i];
            state.style.opacity = 1;
        }
        // 

        d3.selectAll("#myRect")
            .transition()
            .duration(200)
            .style("opacity", 1)
        d3.select(this)
            .transition()
            .duration(200)
            .style("stroke", "none")
        // tooltipTop.transition()
        //     .duration(200)
        //     .style("opacity", 0)
        // drawCircle
        //     .style("opacity", 0)
    }

    // tooltip


    // Bars
    svgTop.selectAll("#myRect")
        .data(data)
        .enter()
        .append("rect")
        .attr("x", function (d) { return x(d.Location); })
        .attr("y", function (d) { return y(d.Value); })
        .attr("width", x.bandwidth())
        .attr("height", function (d) { return 250 - y(d.Value); })
        .attr("fill", "#B6B4DE")
        .on("mouseover", mouseOver)
        .on("mousemove", mousemove)
        .on("mouseleave", mouseLeave)


    var topT = svgTop.selectAll(".topText")
        .data(data)

    topT
        .enter()
        .append("text")
        .merge(topT)
        // .transition()
        // .duration(200)
        .attr("class", "topText")
        .attr("x", function (d) { return x(d.Location); })
        .attr("y", function (d) { return y(d.Value); })
        .attr("dy", "-1em")
        // .attr("dx", "-2em")
        .text(function (d) { return (d.Value) + "%"; })

})



