
// var svg = d3.select("svg"),
//     width = +svg.attr("width"),
//     height = +svg.attr("height");

var svgChange = d3.select("#changeMap")
    .append("svg")
    .attr("width", 1600)
    .attr("height", 1000)

svgChange.append("text")
    .text("Growth in Life Expectancy from 1980 to 2014")
    .attr("x", 500)
    .attr("y", 110)
    .style("font-size", "2vh")
    .attr("font-family", "poppins")
    .attr("fill", '#4E4B4B')


// Map and projection
var path = d3.geoPath();
var projectionChange = d3.geoAlbersUsa()
    // .center([-97, 37])
    .scale(1300)
    // .translate([420, 320])
    .translate([760, 450])



// Data and color scale
var data = d3.map();
var colorScaleChange = d3.scaleThreshold()
    .domain([3, 5, 7, 9, 11, 13])
    // .range(d3.schemePurples[6]);
    .range(["#FFECEC", "#FCCFD3", "#F2A5A2", "#D86764", "#BE403B", "#7E1A14"]);


// Load external data and boot
d3.queue()
    .defer(d3.json, "https://raw.githubusercontent.com/PublicaMundi/MappingAPI/master/data/geojson/us-states.json")
    .defer(d3.csv, "./csvFile/lifeExpChange.csv", function (d) { data.set(d.id, +d.Change); })
    .await(ready);



var tooltipChange = d3.select("#changeMap")
    .append("div")
    .attr("class", "tooltipMap")
    .style("opacity", 0)
    .style("visibility", "visible")


function ready(error, topo) {

    if (error) throw error;

    var mouseOver = function (d) {

        d3.selectAll(".State")
            .transition()
            .duration(200)
            .style("opacity", .5)
        d3.select(this)
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("stroke", "white")
        tooltipChange
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("left", (d3.mouse(this)[0] + 20) + "px")
            .style("top", (d3.mouse(this)[1]) + "px")
    }

    var mousemove = function (d) {
        var state_nameChange = d.properties.name
        var state_totalChange = d.total

        console.log(d)

        tooltipChange
            .html("<h1> 1980 - 2014 Change in Life Expectancy</h1><h1>" + "State Name: " + state_nameChange + "</h1><h1>" + "Life Expectancy Change: " + state_totalChange + "%</h1>")
            .style("width", "16vw")
            .style("height", "10vh")
            .style("font-size", ".8vh")
            .style("left", (d3.mouse(this)[0] + 20) + "px")
            .style("top", (d3.mouse(this)[1]) + "px")
    }

    var mouseLeave = function (d) {
        d3.selectAll(".State")
            .transition()
            .duration(200)
            .style("opacity", 1)
        d3.select(this)
            .transition()
            .duration(200)
            .style("stroke", "white")
        tooltipChange.transition()
            .duration(200)
            .style("opacity", 0)
    }


    // Draw the map
    svgChange.append("g")
        .selectAll("path")
        .data(topo.features)
        .enter()
        .append("path")
        // draw each country
        .attr("d", d3.geoPath()
            .projection(projectionChange)
        )
        // set the color of each country
        .attr("fill", function (d) {
            d.total = data.get(d.id) || 0;
            return colorScaleChange(d.total);
        })
        .style("stroke-width", "2")
        .style("stroke", "white")
        .attr("class", function (d) {
            var name = d.properties.name.replace(/ /g, "_")
            return "State " + name
        })

        .style("opacity", 1)
        .on("mouseover", mouseOver)
        .on("mousemove", mousemove)
        .on("mouseleave", mouseLeave)

}




// svgChange.append('rect')
//     .attr('x', 100)
//     .attr('y', 100)
//     .attr('width', 630)
//     .attr('height', 470)
//     .attr('stroke', 'black')
//     .attr('fill', 'transparent');