// var svg = d3.select("svg"),
//     width = +svg.attr("width"),
//     height = +svg.attr("height");

var svg1995 = d3.select("#life1995")
    .append("svg")
    .attr("width", 1600)
    .attr("height", 1000)

svg1995.append("text")
    .text("Distribution of life expectancy by state, 1995")
    .attr("x", 500)
    .attr("y", 110)
    .style("font-size", "2vh")
    .attr("font-family", "poppins")
    .attr("fill", '#4E4B4B')

// Map and projection
var path = d3.geoPath();
var projection1995 = d3.geoAlbersUsa()
    // .center([-97, 37])
    .scale(1300)
    // .translate([420, 320])
    .translate([760, 450])

// Data and color scale
var data = d3.map();
var colorScale1995 = d3.scaleThreshold()
    .domain([69, 72, 75, 78, 81, 83])
    // .range(d3.schemePurples[7]);
    .range(["#ECECFF", "#DCD9FC", "#BDB9F2", "#9391D0", "#6B6AA6", "#49467D"]);


// Load external data and boot
d3.queue()
    .defer(d3.json, "https://raw.githubusercontent.com/PublicaMundi/MappingAPI/master/data/geojson/us-states.json")
    .defer(d3.csv, "./csvFile/lifeExp1995.csv", function (d) { data.set(d.id, +d.year1995); })
    .await(ready);



var tooltip1995 = d3.select("#life1995")
    .append("div")
    .attr("class", "tooltipMap")
    .style("opacity", 0)
    .style("background-color", "white")
    // .style("border", "solid")
    // .style("border-width", "1px")
    // .style("border-radius", "5px")
    // .style("padding", "8px")
    .style("visibility", "visible")


function ready(error, topo) {

    if (error) throw error;

    var mouseOver = function (d) {

        d3.selectAll(".State")
            .transition()
            .duration(200)
            .style("opacity", .5)
        d3.select(this)
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("stroke", "white")
        tooltip1995
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("left", (d3.mouse(this)[0] + 20) + "px")
            .style("top", (d3.mouse(this)[1]) + "px")
    }

    var mousemove = function (d) {
        var state_name1995 = d.properties.name
        var state_total1995 = d.total

        // console.log(d)

        tooltip1995
            .html("<h1> Year: 1995 </h1><h1>" + "State Name: " + state_name1995 + "</h1><h1>" + "Life Expectancy: " + state_total1995 + "</h1>")
            .style("width", "11vw")
            .style("height", "10vh")
            .style("font-size", "0.8vh")
            .style("left", (d3.mouse(this)[0] + 20) + "px")
            .style("top", (d3.mouse(this)[1]) + "px")
    }

    var mouseLeave = function (d) {
        d3.selectAll(".State")
            .transition()
            .duration(200)
            .style("opacity", 1)
        d3.select(this)
            .transition()
            .duration(200)
            .style("stroke", "white")
        tooltip1995.transition()
            .duration(200)
            .style("opacity", 0)
    }


    // Draw the map
    svg1995.append("g")
        .selectAll("path")
        .data(topo.features)
        .enter()
        .append("path")
        // draw each country
        .attr("d", d3.geoPath()
            .projection(projection1995)
        )
        // set the color of each country
        .attr("fill", function (d) {
            d.total = data.get(d.id) || 0;
            return colorScale1995(d.total);
        })
        // .style("stroke", "transparent")
        .style("stroke-width", "2")
        .style("stroke", "white")
        .attr("class", function (d) {
            var name = d.properties.name.replace(/ /g, "_")
            return "State " + name
        })

        .style("opacity", 1)
        .on("mouseover", mouseOver)
        .on("mousemove", mousemove)
        .on("mouseleave", mouseLeave)
}

// svg1995.append('rect')
//     .attr('x', 100)
//     .attr('y', 100)
//     .attr('width', 630)
//     .attr('height', 470)
//     .attr('stroke', 'black')
//     .attr('fill', 'transparent');