

// set the dimensions and margins of the graph
var margin = { top: 60, right: 30, bottom: 40, left: 50 },
    width = 1460 - margin.left - margin.right,
    height = 450 - margin.top - margin.bottom;

// append the svg object to the body of the page
var svgBottom = d3.select("#Bottom")
    .append("svg")
    .attr("width", width + margin.left + margin.right)
    .attr("height", height + margin.top + margin.bottom)
    .append("g")
    .attr("transform",
        "translate(" + margin.left + "," + margin.top + ")");

svgBottom.append("text")
    .text("Race Distribution")
    .attr("x", 895)
    .attr("y", 8)
    .style("font-size", "1.8vh")
    .attr("font-family", "poppins")
    .attr("fill", '#4E4B4B')

// Parse the Data
d3.csv("./csvFile/ChangeBottom10.csv", function (data) {

    // X axis
    var x = d3.scaleBand()
        .range([0, 800])
        .domain(data.map(function (d) { return d.Location; }))
        .padding(0.5);
    svgBottom.append("g")
        .attr("transform", "translate(0,250)")
        .call(d3.axisBottom(x))
        .selectAll("text")
        .attr("transform", "translate(-10,0)rotate(-45)")
        .style("text-anchor", "end");




    // Add Y axis
    var y = d3.scaleLinear()
        .domain([0, 14])
        .range([250, 0]);
    svgBottom.append("g")
    // .call(d3.axisLeft(y));

    var tooltipBottom = d3.select("#Bottom")
        .append("div")
        .attr("class", "tooltipBar")
        .style("opacity", 1)
        .style("visibility", "visible")

    var mouseOver = function (d) {
        // for HOVER
        var remains_state = document.getElementsByClassName("State");

        for (let i = 0; i < remains_state.length; i++) {
            var state = remains_state[i];
            state.style.opacity = 0.25;
        }

        var location_name = d.Location.replace(/ /g, "_");
        var ele = document.getElementsByClassName(location_name)
        for (let i = 0; i < ele.length; i++) {
            var state = ele[i];
            state.style.opacity = 1;
        }
        //

        d3.selectAll("#myRect")
            .transition()
            .duration(200)
            .style("opacity", .5)
        d3.select(this)
            .transition()
            .duration(200)
            .style("opacity", 1)
            .style("stroke", "black")
        tooltipBottom
            .transition()
            .duration(200)
            .style("opacity", 1)

    }

    var mousemove = function (d) {
        console.log(d)

        tooltipBottom
            .html("<br><h1>" + "States: " + d.Location + " <br><br> </h1><h1>  "
                + "White Alone: " + d.White + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "Black Alone: "
                + d.Black + "<br><br><br><br></h1><h1>" + "Other Alone: "
                + d.Other + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "Mixed Races: " + d.Mix)
            .style("font-family", "poppins")
            .style("text-align", "left")
            .style("left", "935px")
            .style("width", "500px")
            .style("top", "60px")
            .style("font-size", "9px")
            .style("opacity", 1)

    }

    var mouseLeave = function (d) {
        // For reverse HOVER
        var remains_state = document.getElementsByClassName("State");

        for (let i = 0; i < remains_state.length; i++) {
            var state = remains_state[i];
            state.style.opacity = 1;
        }
        // 

        d3.selectAll("#myRect")
            .transition()
            .duration(200)
            .style("opacity", 1)
        d3.select(this)
            .transition()
            .duration(200)
            .style("stroke", "none")
        // tooltipBottom.transition()
        //     .duration(200)
        //     .style("opacity", 0)
        // drawCircle
        //     .style("opacity", 0)
    }


    // Bars
    svgBottom.selectAll("#myRect")
        .data(data)
        .enter()
        .append("rect")
        .attr("x", function (d) { return x(d.Location); })
        .attr("y", function (d) { return y(d.Value); })
        .attr("width", x.bandwidth())
        .attr("height", function (d) { return 250 - y(d.Value); })
        .attr("fill", "#B6B4DE")
        // .append("text")
        // .attr("x", function (d) { return x(d.Location); })
        // .attr("y", function (d) { return y(d.Value); })
        // .attr("fill", "black")
        // .text(11111)
        .on("mouseover", mouseOver)
        .on("mousemove", mousemove)
        .on("mouseleave", mouseLeave)



    var bottomT = svgBottom.selectAll(".bottomText")
        .data(data)

    bottomT
        .enter()
        .append("text")
        .merge(bottomT)
        // .transition()
        // .duration(200)
        .attr("class", "bottomText")
        .attr("x", function (d) { return x(d.Location); })
        .attr("y", function (d) { return y(d.Value); })
        .attr("dy", "-1em")
        // .attr("dx", "-2em")
        .text(function (d) { return (d.Value) + "%"; })
})

