{
  d3.select("#button_container")
    .selectAll("button")
    .on("click", function (e) {
      const selectedData = this.getAttribute("value");
      updateBar(selectedData);
      //match()function is so damn brilliant
      const selectedText = this.innerText.match(/[ ]*(.*)/)[1];

      d3.select(".Barchat_button").text(
        `Price of ${selectedText} in following countries:`
      );
    });
}

function myButtonClicked(obj) {
  obj.setAttribute("disabled", true);
}

const allDatas = {
  data1: [
    { group: "US", value: 1199, color: "#F8C096" },
    { group: "UK", value: 788, color: "#EEDCC2" },
    { group: "Switzerland", value: 503, color: "#EEDCC2" },
    { group: "Spain", value: 85, color: "#EEDCC2" },
  ],

  data2: [
    { group: "US", value: 5061, color: "#F8C096" },
    { group: "UK", value: 4046, color: "#EEDCC2" },
    { group: "Switzerland", value: 181, color: "#EEDCC2" },
    { group: "Spain", value: 2974, color: "#EEDCC2" },
  ],

  data3: [
    { group: "US", value: 15930, color: "#F8C096" },
    { group: "UK", value: 8009, color: "#EEDCC2" },
    { group: "Switzerland", value: 6040, color: "#EEDCC2" },
    { group: "Spain", value: 2003, color: "#EEDCC2" },
  ],

  data4: [
    { group: "US", value: 78318, color: "#F8C096" },
    { group: "UK", value: 24059, color: "#EEDCC2" },
    { group: "Switzerland", value: 34224, color: "#EEDCC2" },
    { group: "Spain", value: 14579, color: "#EEDCC2" },
  ],

  data5: [
    { group: "US", value: 32114, color: "#F8C096" },
    { group: "UK", value: 22554, color: "#EEDCC2" },
    { group: "Switzerland", value: 16861, color: "#EEDCC2" },
    { group: "Spain", value: 18165, color: "#EEDCC2" },
  ],

  data6: [
    { group: "US", value: 2669, color: "#F8C096" },
    { group: "UK", value: 1362, color: "#EEDCC2" },
    { group: "Switzerland", value: 822, color: "#EEDCC2" },
    { group: "Spain", value: 1253, color: "#EEDCC2" },
  ],
};

let colorArray = ["#1F83DE", "#A5A2A2", "#A5A2A2", "#A5A2A2"];
//const find_max= d =>d.value;

// set the dimensions and margins of the graph
// set the dimensions and margins of the graph
const margin_bar = { top: 30, right: 30, bottom: 70, left: 60 },
  width_bar = 700 - margin_bar.left - margin_bar.right,
  height_bar = 400 - margin_bar.top - margin_bar.bottom;

// append the svg object to the body of the page
const svg = d3
  .select("#my_dataviz")
  .append("svg")
  .attr("width", width_bar + margin_bar.left + margin_bar.right)
  .attr("height", height_bar + margin_bar.top + margin_bar.bottom)
  .append("g")
  //.attr("transform", "translate(" + margin.bottom + "," + margin.top + ")");
  .attr(
    "transform",
    `translate(${margin_bar.bottom - 20},${margin_bar.left + 50})`
  );

///////////////////////////////////////
/**
 *  Newly added code
 */
const dataImg = d3
  .select("#my_dataviz")
  .append("img")
  .style("margin-bottom", margin_bar.bottom - 50 + "px")
  .style("margin-top", margin_bar.top + 10 + "px")
  //.style('margin-top', margin.top + 'px')
  .style("margin-left", margin_bar.left + 100 + "px")
  .attr("height", height_bar + margin_bar.top - 25)
  .attr("src", "pic1.png");
//////////////////////////////////////////

// Initialize the X axis
const y_pos = d3.scaleBand().range([0, height_bar]).padding(0.4);
const yAxis_bar = svg.append("g");
//.attr("transform", `translate(0,${height})`)

// Initialize the Y axis
const x_pos = d3.scaleLinear().range([0, width_bar]);
const xAxis_bar = svg.append("g");

function updateBar(dataKey) {
  const picName = dataKey.replace("data", "pic") + ".png";
  dataImg.attr("src", "code/" + picName);

  const data = allDatas[dataKey];
  // Update the X axis
  y_pos.domain(data.map((d) => d.group));
  yAxis_bar.transition().duration(1000);
  //.call(d3.axisLeft(y))

  // Update the Y axis
  x_pos.domain([0, d3.max(data, (d) => d.value)]);
  //xAxis.call(d3.axisTop(x));

  var tooltip = d3
    .select("#my_dataviz")
    .append("div")
    .style("opacity", 0)
    .attr("class", "tooltip");
  /*  .style("background-color", "black")
    .style("color", "white")
    .style("border-radius", "5px")
    .style("padding", "10px") */

  var mouseover = function (d) {
    tooltip.style("opacity", 1);
  };
  var mousemove = function (d) {
    const toolTipMessage = `${d.group}<br/>Price: $${d.value}`;
    tooltip
      .html(toolTipMessage)
      .style("left", d3.mouse(this)[0] + 600 + "px") // It is important to put the +90: other wise the tooltip is exactly where the point is an it creates a weird effect
      .style("top", d3.mouse(this)[1] + 900 + "px");
  };

  var mouseleave = function (d) {
    tooltip.transition().duration(200).style("opacity", 0);
  };

  // A function that change this tooltip when the leaves a point: just need to set opacity to 0 again
  //var hideTooltip = function (d) {
  //tooltip.transition().duration(100).style("opacity", 0);
  //};

  // Create the u variable
  var u = svg
    .selectAll("rect")
    .data(data)
  // .on("mouseover", mouseover)
  // .on("mousemove", mousemove)
  // .on("mouseleave", mouseleave);

  u
    // .join("rect") // Add a new rect for each new elements
    .enter()
    .append("rect")
    .merge(u)
    .transition()
    .duration(1000)
    .attr("y", (d) => y_pos(d.group))
    .attr("x", (d) => 0)
    //.attr("x", d => x(d.value))
    .attr("width", (d) => x_pos(d.value))
    .attr("height", y_pos.bandwidth())
    //.attr("fill", "#69b3a2")
    .attr("fill", (d) => d.color)
    .attr("opacity", 1);

  svg
    .append("g")
    .attr("transform", "translate(-10,20)")
    .attr("fill", "black")
    .attr("font-weight", "bold")
    .attr("text-anchor", "end")
    .attr("font-size", 13)
    .style("font", "10px Verdana, Helvetica, Arial, sans-serif")
    .selectAll("text")
    .data(data)
    // .join('text')
    .enter()
    .append("text")
    // .merge()
    .attr("x", (d) => 0)
    .attr("y", (d) => y_pos(d.group))
    .attr("dy", "0.1em")
    .text((d) => d.group);

  //append spending ($) of different countries
  const valueS = svg.selectAll(".showValue").data(data);
  valueS
    .enter()
    .append("text")
    .merge(valueS)
    // .transition()
    // .duration(200)
    .attr("class", "showValue")
    .attr("transform", "translate(-10,23)")
    .attr("text-anchor", "start")

    //.attr("x", (d) => x_pos(d.value))
    .attr("x", (d) => 25)
    .attr("y", (d) => y_pos(d.group))
    .attr("dy", "0.1em")
    // .attr("dx", "-2em")
    // .text((d) => d.value);
    .text(function (d) {
      return "$ " + d.value;
    });
}

// Initialize the plot with the first dataset
updateBar("data1");
