// targeting the svg itself
const svg1 = document.getElementById("SydneyMap");

// variable for the namespace 
const svgns = "http://www.w3.org/2000/svg";

//define canvas details
height = 800;
width = 1400;

//  parameters used to draw the circles
const circumference = 3.14;
const area = ['Ashfield', 'Botany Bay', 'Burwood', 'Canada Bay', 'Hunters Hill', 'Lane Cove', 'Leichhardt', 'Manly', 'Marrickville', 'Mosman', 'North Sydney', 'Randwick', 'Sydney', 'Waverley', 'Willoughby', 'Woollahra', 'Total'];
const percentage = [0.368, 0.347, 0.456, 0.375, 0.389, 0.494, 0.476, 0.489, 0.37, 0.489, 0.433, 0.294, 0.404, 0.338, 0.401, 0.345, 0.384];
const compare1 = ['36.8%', '34.7%', '45.6%', '37.5%', '38.9%', '49.4%', '47.6%', '48.9%', '37%', '48.9%', '43.3%', '29.4%', '40.4%', '33.8%', '40.1%', '34.5%', '38.4%'];
const compare2 = ['63.2%', '65.3%', '54.4%', '62.5%', '61.1%', '50.6%', '52.4%', '51.1%', '63%', '51.1%', '56.7%', '70.6%', '59.6%', '66.2%', '59.9%', '65.5%', '61.6%'];
const longTerm = ['110', '245', '106', '165', '22', '83', '263', '535', '400', '143', '434', '1261', '2868', '1840', '188', '538', '9201'];
const shortTerm = ['64', '130', '89', '99', '14', '81', '239', '511', '235', '137', '331', '524', '1943', '938', '126', '284', '5745'];
const listing = ['174', '375', '195', '264', '36', '164', '502', '1046', '635', '280', '765', '1785', '4811', '2778', '314', '822', '14946'];
const density = ['21', '23', '27', '13', '6', '16', '47', '73', '38', '32', '73', '57', '192', '297', '14', '67', '65'];

// circle outside the map
var circle = document.createElementNS(svgns, "circle");

circle.setAttributeNS(null, "cx", 740);
circle.setAttributeNS(null, "cy", 1280);
circle.setAttributeNS(null, "r", 490);
circle.setAttributeNS(null, 'style', 'fill: none; stroke:#262626; stroke-width: 2px; stroke-dasharray:20;');
svg1.appendChild(circle);


function drawCircle(x, y, i, r, diagram_className, land_id, all_id) {

    var rect = document.createElementNS(svgns, "rect");

    // add class name
    rect.classList.add('diagram');
    rect.classList.add(diagram_className);

    rect.setAttributeNS(null, "x", x - 60);
    rect.setAttributeNS(null, "y", y + 65);
    rect.setAttributeNS(null, "width", 120);
    rect.setAttributeNS(null, "height", 30);
    rect.setAttributeNS(null, 'style', 'fill: #EBE7DD; stroke:#A5A5A5; stroke-width:2px;');
    svg1.appendChild(rect);

    var circle = document.createElementNS(svgns, "circle");

    // add class name
    circle.classList.add('diagram');
    circle.classList.add(diagram_className);

    circle.setAttributeNS(null, "cx", x);
    circle.setAttributeNS(null, "cy", y);
    circle.setAttributeNS(null, "r", r);
    circle.setAttributeNS(null, 'style', 'fill: #C69784;');
    svg1.appendChild(circle);


    var circle = document.createElementNS(svgns, "circle");

    // add class name
    circle.classList.add('diagram');
    circle.classList.add(diagram_className);

    circle.setAttributeNS(null, "cx", x);
    circle.setAttributeNS(null, "cy", y);
    circle.setAttributeNS(null, "r", r / 2);
    circle.setAttributeNS(null, 'style', 'fill: transparent; stroke: #E7C090; stroke-width:' + Math.floor(r) + 'px; stroke-dasharray:' + Math.floor(percentage[i] * circumference * r) + ' ' + Math.floor(circumference * r) + '  ;');
    circle.setAttributeNS(null, 'transform', 'rotate(-90 ' + x + ', ' + y + ')');
    svg1.appendChild(circle);


    var text = document.createElementNS(svgns, 'text');

    // add class name
    text.classList.add('diagram');
    text.classList.add(diagram_className);

    text.setAttributeNS(null, 'x', x);
    text.setAttributeNS(null, 'y', y + 85);
    text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    text.setAttributeNS(null, 'font-size', '14');
    text.setAttributeNS(null, 'font-weight', 'bold');
    text.textContent = area[i];
    text.setAttributeNS(null, 'fill', '#6F7381');
    svg1.appendChild(text);


    // lable percentage
    // long term data 
    // var text = document.createElementNS(svgns, 'text');

    // add class name
    // text.classList.add('diagram');
    // text.classList.add(diagram_className);

    // text.setAttributeNS(null, 'x', x - 30);
    // text.setAttributeNS(null, 'y', y);
    // text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    // text.setAttributeNS(null, 'font-size', '14');
    // text.textContent = longTerm[i];
    // text.setAttributeNS(null, 'fill', '#FFFFFF');
    // svg1.appendChild(text);

    var text = document.createElementNS(svgns, 'text');

    // add class name
    text.classList.add('diagram');
    text.classList.add(diagram_className);

    text.setAttributeNS(null, 'x', x - 30);
    text.setAttributeNS(null, 'y', y + 10);
    text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    text.setAttributeNS(null, 'font-size', '14');
    text.textContent = compare2[i];
    text.setAttributeNS(null, 'fill', '#FFFFFF');
    svg1.appendChild(text);

    // short term data 
    var text = document.createElementNS(svgns, 'text');

    // add class name
    text.classList.add('diagram');
    text.classList.add(diagram_className);

    text.setAttributeNS(null, 'x', x + 30);
    text.setAttributeNS(null, 'y', y);
    text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    text.setAttributeNS(null, 'font-size', '14');
    text.textContent = compare1[i];
    text.setAttributeNS(null, 'fill', '#FFFFFF');
    svg1.appendChild(text);

    // var text = document.createElementNS(svgns, 'text');

    // add class name
    // text.classList.add('diagram');
    // text.classList.add(diagram_className);

    // text.setAttributeNS(null, 'x', x + 30);
    // text.setAttributeNS(null, 'y', y - 20);
    // text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    // text.setAttributeNS(null, 'font-size', '14');
    // text.textContent = shortTerm[i];
    // text.setAttributeNS(null, 'fill', '#FFFFFF');
    // svg1.appendChild(text);

    console.log("#" + land_id)
    // add listener 
    $("#" + land_id).on("click", function (e) {
        $("." + diagram_className).toggle("transition: all 0.2s ease - out"); // togggle = display
    })

    // reveal or hide all the diagrams
    $("#" + all_id).on("click", function (e) {
        $("." + diagram_className).toggle("transition: all 0.2s ease - out"); // togggle = display
    })

    // $("#" + land_id).on("mouseenter", function (e) {
    //     $("." + diagram_className).show(); // togggle = display
    // }).on("mouseleave", function (e) {
    //     $("." + diagram_className).hide();
    // });

}

// pie chart_Ashfield
drawCircle(470, 1290, 0, 70, "Ashfield_diagram", "Ashfield", "showAll");
// pie chart_Botany Bay
drawCircle(740, 1480, 1, 70, "BotanyBay_diagram", "BotanyBay", "showAll");
// pie chart_Burwood
drawCircle(320, 1290, 2, 70, "Burwood_diagram", "Burwood", "showAll");
// pie chart_Canada Bay
drawCircle(350, 1130, 3, 70, "CanadaBay_diagram", "CanadaBay", "showAll");
// pie chart_Hunters Hill
drawCircle(460, 1020, 4, 70, "HuntersHill_diagram", "HuntersHill", "showAll");
// pie chart_Lane Cove
drawCircle(580, 980, 5, 70, "LaneCove_diagram", "LaneCove", "showAll");
// pie chart_Leichhardt
drawCircle(590, 1180, 6, 70, "Leichhardt_diagram", "Leichhardt", "showAll");
// pie chart_Manly
drawCircle(1000, 900, 7, 70, "Manly_diagram", "Manly", "showAll");
// pie chart_Marrickville
drawCircle(580, 1350, 8, 70, "Marrickville_diagram", "Marrickville", "showAll");
// pie chart_Mosman
drawCircle(910, 1050, 9, 70, "Mosman_diagram", "Mosman", "showAll");
// pie chart_North Sydney
drawCircle(780, 1070, 10, 70, "NorthSydney_diagram", "NorthSydney", "showAll");
// pie chart_Randwick
drawCircle(900, 1480, 11, 70, "Randwick_diagram", "Randwick", "showAll");
// pie chart_Sydney
drawCircle(740, 1280, 12, 70, "Sydney_diagram", "Sydney", "showAll");
// pie chart_Waverley
drawCircle(1030, 1320, 13, 70, "Waverley_diagram", "Waverley", "showAll");
// pie chart_Willoughby
drawCircle(720, 920, 14, 70, "Willoughby_diagram", "Willoughby", "showAll");
// pie chart_Woollahra
drawCircle(920, 1220, 15, 70, "Woollahra_diagram", "Woollahra", "showAll");



//List Number

var rect = document.createElementNS(svgns, "rect");

rect.setAttributeNS(null, "x", 540);
rect.setAttributeNS(null, "y", 730);
rect.setAttributeNS(null, "width", 400);
rect.setAttributeNS(null, "height", 120);
rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:2px;');
svg1.appendChild(rect);

var rect = document.createElementNS(svgns, "rect");

rect.setAttributeNS(null, "x", 550);
rect.setAttributeNS(null, "y", 740);
rect.setAttributeNS(null, "width", 380);
rect.setAttributeNS(null, "height", 100);
rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:1px;');
svg1.appendChild(rect);

var text = document.createElementNS(svgns, 'text');

text.setAttributeNS(null, 'x', 740);
text.setAttributeNS(null, 'y', 770);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '22');
text.textContent = "Total";
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

var text = document.createElementNS(svgns, 'text');

text.setAttributeNS(null, 'x', 740);
text.setAttributeNS(null, 'y', 798);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '22');
text.textContent = "Listing Number: " + listing[16];
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);


var text = document.createElementNS(svgns, 'text');

text.setAttributeNS(null, 'x', 740);
text.setAttributeNS(null, 'y', 826);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '22');
text.textContent = "Listing Density: " + density[16] + " " + "listings / km²";
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);


function ListNumber(i, listNumber_className, land_id) {

    var rect = document.createElementNS(svgns, "rect");

    // add class name
    rect.classList.add('listNumber');
    rect.classList.add(listNumber_className);

    rect.setAttributeNS(null, "x", 540);
    rect.setAttributeNS(null, "y", 730);
    rect.setAttributeNS(null, "width", 400);
    rect.setAttributeNS(null, "height", 120);
    rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:2px;');
    svg1.appendChild(rect);

    var rect = document.createElementNS(svgns, "rect");

    // add class name
    rect.classList.add('listNumber');
    rect.classList.add(listNumber_className);

    rect.setAttributeNS(null, "x", 550);
    rect.setAttributeNS(null, "y", 740);
    rect.setAttributeNS(null, "width", 380);
    rect.setAttributeNS(null, "height", 100);
    rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:1px;');
    svg1.appendChild(rect);

    var text = document.createElementNS(svgns, 'text');

    // add class name
    text.classList.add('listNumber');
    text.classList.add(listNumber_className);

    text.setAttributeNS(null, 'x', 740);
    text.setAttributeNS(null, 'y', 770);
    text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    text.setAttributeNS(null, 'font-size', '22');
    text.textContent = area[i];
    text.setAttributeNS(null, 'fill', '#6F7381');
    svg1.appendChild(text);

    var text = document.createElementNS(svgns, 'text');

    // add class name
    text.classList.add('listNumber');
    text.classList.add(listNumber_className);

    text.setAttributeNS(null, 'x', 740);
    text.setAttributeNS(null, 'y', 798);
    text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    text.setAttributeNS(null, 'font-size', '22');
    text.textContent = " Listing Number: " + listing[i];
    text.setAttributeNS(null, 'fill', '#6F7381');
    svg1.appendChild(text);

    var text = document.createElementNS(svgns, 'text');

    // add class name
    text.classList.add('listNumber');
    text.classList.add(listNumber_className);

    text.setAttributeNS(null, 'x', 740);
    text.setAttributeNS(null, 'y', 826);
    text.setAttributeNS(null, 'style', 'text-anchor: middle;');
    text.setAttributeNS(null, 'font-size', '22');
    text.textContent = " Listing Density: " + density[i] + " " + "listings / km²";
    text.setAttributeNS(null, 'fill', '#6F7381');
    svg1.appendChild(text);

    $("#" + land_id).on("mouseenter", function (e) {
        $("." + listNumber_className).show();
    }).on("mouseleave", function (e) {
        $("." + listNumber_className).hide();
    });
}


// ListNumber_Ashfield
ListNumber(0, "Ashfield_list", "Ashfield");
// ListNumber_Botany Bay
ListNumber(1, "BotanyBay_list", "BotanyBay");
// ListNumber_Burwood
ListNumber(2, "Burwood_list", "Burwood");
// ListNumber_Canada Bay
ListNumber(3, "CanadaBay_list", "CanadaBay");
// ListNumber_Hunters Hill
ListNumber(4, "HuntersHill_list", "HuntersHill");
// ListNumber_Lane Cove
ListNumber(5, "LaneCove_list", "LaneCove");
// ListNumber_Leichhardt
ListNumber(6, "Leichhardt_list", "Leichhardt");
// ListNumber_Manly
ListNumber(7, "Manly_list", "Manly");
// ListNumber_Marrickville
ListNumber(8, "Marrickville_list", "Marrickville");
// ListNumber_Mosman
ListNumber(9, "Mosman_list", "Mosman");
// ListNumber_North Sydney
ListNumber(10, "NorthSydney_list", "NorthSydney");
// ListNumber_Randwick
ListNumber(11, "Randwick_list", "Randwick");
// ListNumber_Sydney
ListNumber(12, "Sydney_list", "Sydney");
// ListNumber_Waverley
ListNumber(13, "Waverley_list", "Waverley");
// ListNumber_Willoughby
ListNumber(14, "Willoughby_list", "Willoughby");
// ListNumber_Woollahra
ListNumber(15, "Woollahra_list", "Woollahra");


// overall pie chart
var rect = document.createElementNS(svgns, "rect");

rect.setAttributeNS(null, "x", 1150);
rect.setAttributeNS(null, "y", 1800);
rect.setAttributeNS(null, "width", 200);
rect.setAttributeNS(null, "height", 65);
rect.setAttributeNS(null, 'style', 'fill: none; stroke:#A5A5A5; stroke-width:4px;');
svg1.appendChild(rect);

var circle = document.createElementNS(svgns, "circle");

circle.setAttributeNS(null, "cx", 1250);
circle.setAttributeNS(null, "cy", 1600);
circle.setAttributeNS(null, "r", 210);
circle.setAttributeNS(null, 'style', 'fill: #C69784;');
svg1.appendChild(circle);


var circle = document.createElementNS(svgns, "circle");

circle.setAttributeNS(null, "cx", 1250);
circle.setAttributeNS(null, "cy", 1600);
circle.setAttributeNS(null, "r", 105);
circle.setAttributeNS(null, 'style', 'fill: transparent; stroke: #E7C090; stroke-width:210px; stroke-dasharray:' + Math.floor(0.419 * circumference * 210) + ' ' + Math.floor(circumference * 210) + '  ;');
circle.setAttributeNS(null, 'transform', 'rotate(-90 1250, 1600)');
svg1.appendChild(circle);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1250);
text.setAttributeNS(null, 'y', 1850);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '32');
text.setAttributeNS(null, 'font-weight', 'bold');
text.textContent = area[16];
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

// // lable percentage
// var text = document.createElementNS(svgns, 'text');

// text.setAttributeNS(null, 'x', 1250 - 70);
// text.setAttributeNS(null, 'y', 1600);
// text.setAttributeNS(null, 'style', 'text-anchor: middle;');
// text.setAttributeNS(null, 'font-size', '28');
// text.textContent = longTerm[16];
// text.setAttributeNS(null, 'fill', '#FFFFFF');
// svg1.appendChild(text);

var text = document.createElementNS(svgns, 'text');

text.setAttributeNS(null, 'x', 1250 - 80);
text.setAttributeNS(null, 'y', 1610);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '28');
text.textContent = compare2[16];
text.setAttributeNS(null, 'fill', '#FFFFFF');
svg1.appendChild(text);

// short term data 
var text = document.createElementNS(svgns, 'text');

text.setAttributeNS(null, 'x', 1250 + 80);
text.setAttributeNS(null, 'y', 1610);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '28');
text.textContent = compare1[16];
text.setAttributeNS(null, 'fill', '#FFFFFF');
svg1.appendChild(text);

// var text = document.createElementNS(svgns, 'text');

// text.setAttributeNS(null, 'x', 1250 + 70);
// text.setAttributeNS(null, 'y', 1600 - 40);
// text.setAttributeNS(null, 'style', 'text-anchor: middle;');
// text.setAttributeNS(null, 'font-size', '28');
// text.textContent = shortTerm[16];
// text.setAttributeNS(null, 'fill', '#FFFFFF');
// svg1.appendChild(text);

// circle outside overall pie chart
var circle = document.createElementNS(svgns, "circle");

circle.setAttributeNS(null, "cx", 1250);
circle.setAttributeNS(null, "cy", 1600);
circle.setAttributeNS(null, "r", 220);
circle.setAttributeNS(null, 'style', 'fill: none; stroke:#262626; stroke-width: 2px; stroke-dasharray:15;');
svg1.appendChild(circle);


//legend_outside rects
function drawLegend(x, y) {
    var rect = document.createElementNS(svgns, "rect");

    rect.setAttributeNS(null, "x", x);
    rect.setAttributeNS(null, "y", y);
    rect.setAttributeNS(null, "width", 250);
    rect.setAttributeNS(null, "height", 350);
    rect.setAttributeNS(null, 'style', 'fill: none; stroke:#A5A5A5; stroke-width:1.5px;');
    svg1.appendChild(rect);

    var rect = document.createElementNS(svgns, "rect");

    rect.setAttributeNS(null, "x", x - 15);
    rect.setAttributeNS(null, "y", y - 15);
    rect.setAttributeNS(null, "width", 280);
    rect.setAttributeNS(null, "height", 380);
    rect.setAttributeNS(null, 'style', 'fill: none; stroke:#A5A5A5; stroke-width:3px;');
    svg1.appendChild(rect);

    var rect = document.createElementNS(svgns, "rect");

    rect.setAttributeNS(null, "x", x + 35);
    rect.setAttributeNS(null, "y", y - 45);
    rect.setAttributeNS(null, "width", 180);
    rect.setAttributeNS(null, "height", 70);
    rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:2px;');
    svg1.appendChild(rect);

    var rect = document.createElementNS(svgns, "rect");

    rect.setAttributeNS(null, "x", x + 45);
    rect.setAttributeNS(null, "y", y - 35);
    rect.setAttributeNS(null, "width", 160);
    rect.setAttributeNS(null, "height", 50);
    rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:1.5px;');
    svg1.appendChild(rect);

}

// legend_pie chart

// outside rects
drawLegend(1400, 950);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1525);
text.setAttributeNS(null, 'y', 935);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '16');
text.setAttributeNS(null, 'font-weight', 'bold');
text.textContent = 'RENTAL LENGTH';
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1525);
text.setAttributeNS(null, 'y', 955);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '16');
text.setAttributeNS(null, 'font-weight', 'bold');
text.textContent = 'DISTRIBUTION';
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

// draw the Schematic diagram
var rect = document.createElementNS(svgns, "rect");

rect.setAttributeNS(null, "x", 1465);
rect.setAttributeNS(null, "y", 1100);
rect.setAttributeNS(null, "width", 120);
rect.setAttributeNS(null, "height", 30);
rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:2px;');
svg1.appendChild(rect);

var circle = document.createElementNS(svgns, "circle");

circle.setAttributeNS(null, "cx", 1525);
circle.setAttributeNS(null, "cy", 1050);
circle.setAttributeNS(null, "r", 60);
circle.setAttributeNS(null, 'style', 'fill: #C69784;');
svg1.appendChild(circle);


var circle = document.createElementNS(svgns, "circle");

circle.setAttributeNS(null, "cx", 1525);
circle.setAttributeNS(null, "cy", 1050);
circle.setAttributeNS(null, "r", 30);
circle.setAttributeNS(null, 'style', 'fill: transparent; stroke: #E7C090; stroke-width:60px; stroke-dasharray:' + Math.floor(0.5 * circumference * 60) + ' ' + Math.floor(circumference * 60) + '  ;');
circle.setAttributeNS(null, 'transform', 'rotate(-90 1525, 1050)');
svg1.appendChild(circle);

// var text = document.createElementNS(svgns, 'text');
// text.setAttributeNS(null, 'x', 1525);
// text.setAttributeNS(null, 'y', 1050);
// text.setAttributeNS(null, 'style', 'text-anchor: middle;');
// text.setAttributeNS(null, 'font-size', '12');
// text.setAttributeNS(null, 'font-weight', 'normal');
// text.textContent = 'Rental Number';
// text.setAttributeNS(null, 'fill', '#FFFFFF');
// svg1.appendChild(text);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1525);
text.setAttributeNS(null, 'y', 1055);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '14');
text.setAttributeNS(null, 'font-weight', 'normal');
text.textContent = 'Percentage';
text.setAttributeNS(null, 'fill', '#FFFFFF');
svg1.appendChild(text);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1525);
text.setAttributeNS(null, 'y', 1123);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '14');
text.setAttributeNS(null, 'font-weight', 'bold');
text.textContent = 'AREA';
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

// create function for the text description
var rentalText = ['LONG-TERM RENTAL', 'SHORT-TERM RENTAL'];
var rentalColor = ['#C69784', '#E7C090'];

function legendText(x, y, i) {
    var rect = document.createElementNS(svgns, "rect");

    rect.setAttributeNS(null, "x", x);
    rect.setAttributeNS(null, "y", y);
    rect.setAttributeNS(null, "width", 25);
    rect.setAttributeNS(null, "height", 25);
    rect.setAttributeNS(null, 'style', 'fill: ' + rentalColor[i] + '; stroke:none;');
    svg1.appendChild(rect);

    var text = document.createElementNS(svgns, 'text');
    text.setAttributeNS(null, 'x', x + 40);
    text.setAttributeNS(null, 'y', y + 16);
    text.setAttributeNS(null, 'font-size', '14');
    text.setAttributeNS(null, 'font-weight', 'bold');
    text.textContent = rentalText[i];
    text.setAttributeNS(null, 'fill', '#6F7381');
    svg1.appendChild(text);

}
// create text description
legendText(1435, 1170, 0);
legendText(1435, 1220, 1);


// legend_map color
// outside rects
drawLegend(1400, 500);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1525);
text.setAttributeNS(null, 'y', 485);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '16');
text.setAttributeNS(null, 'font-weight', 'bold');
text.textContent = 'LISTING DENSITY';
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

var text = document.createElementNS(svgns, 'text');
text.setAttributeNS(null, 'x', 1525);
text.setAttributeNS(null, 'y', 505);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '16');
text.setAttributeNS(null, 'font-weight', 'bold');
text.textContent = '(Listings / km²)';
text.setAttributeNS(null, 'fill', '#6F7381');
svg1.appendChild(text);

// create functions for the map color description
var mapColor = ['#C7CDE0', '#9BA1B3', '#616A85', '#3B4257'];
var mapText = ['0 - 30', '30 - 60', '60 - 90', '> 90'];

function mapMatch(x, y, i) {
    var rect = document.createElementNS(svgns, "rect");

    rect.setAttributeNS(null, "x", x);
    rect.setAttributeNS(null, "y", y);
    rect.setAttributeNS(null, "width", 40);
    rect.setAttributeNS(null, "height", 40);
    rect.setAttributeNS(null, 'style', 'fill: ' + mapColor[i] + '; stroke:none;');
    svg1.appendChild(rect);

    var text = document.createElementNS(svgns, 'text');
    text.setAttributeNS(null, 'x', x + 68);
    text.setAttributeNS(null, 'y', y + 25);
    text.setAttributeNS(null, 'font-size', '18');
    text.setAttributeNS(null, 'font-weight', 'bold');
    text.textContent = mapText[i];
    text.setAttributeNS(null, 'fill', '#6F7381');
    svg1.appendChild(text);


}

mapMatch(1455, 570, 0);
mapMatch(1455, 630, 1);
mapMatch(1455, 690, 2);
mapMatch(1455, 750, 3);


// tittle

var rect = document.createElementNS(svgns, "rect");

rect.setAttributeNS(null, "x", 130);
rect.setAttributeNS(null, "y", 310);
rect.setAttributeNS(null, "width", 1140);
rect.setAttributeNS(null, "height", 100);
rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:2px;');
svg1.appendChild(rect);

var rect = document.createElementNS(svgns, "rect");

rect.setAttributeNS(null, "x", 150);
rect.setAttributeNS(null, "y", 320);
rect.setAttributeNS(null, "width", 1100);
rect.setAttributeNS(null, "height", 80);
rect.setAttributeNS(null, 'style', 'fill: #fffaef; stroke:#A5A5A5; stroke-width:1px;');
svg1.appendChild(rect);

var text = document.createElementNS(svgns, 'text');

text.setAttributeNS(null, 'x', 700);
text.setAttributeNS(null, 'y', 370);
text.setAttributeNS(null, 'style', 'text-anchor: middle;');
text.setAttributeNS(null, 'font-size', '28');
text.textContent = "What is the listings density and rental length distribution in Sydney area?";
text.setAttributeNS(null, 'fill', '#3B4257');
svg1.appendChild(text);



