d3.csv('air_bnb.csv').then(function (data) {
    data.forEach(d => {
        d.average_nights_booked = +d.average_nights_booked;
        d.income = +d.income;
        d.total_listings = +d.total_listings;
        d.price = +d.price;

    });
    console.log(data);
    draw(data);
});

const margin_bubble = { top: 250, right: 790, bottom: 30, left: 200 },
    width_1 = window.innerWidth - margin_bubble.left - margin_bubble.right,
    height_1 = 850 - margin_bubble.top - margin_bubble.bottom;

y = 1000;



const svg_bubble = d3.select('#my_dataviz')
    .append("svg")
    .attr("width", width_1 + margin_bubble.left + margin_bubble.right)
    .attr("height", height_1 + margin_bubble.top + margin_bubble.bottom)
    .append("g")
    .attr("transform", `translate(${margin_bubble.left},${margin_bubble.top})`);


const draw = data => {
    const xValue = d => d.average_nights_booked;
    const yValue = d => d.income;
    const zValue = d => d.price;
    const colorValue = d => d.color_bubble;
    const nameValue = d => d.Area;
    const priceValue = d => d.price;


    const xScale = d3.scaleLinear()
        .domain([0, d3.max(data, xValue)])
        .range([0, width_1]);
    svg_bubble.append("g")
        .attr("transform", `translate(0, ${height_1})`)
        .call(d3.axisBottom(xScale));

    console.log(xScale.domain());
    console.log(xScale.range());

    const yScale = d3.scaleLinear()
        .domain([d3.min(data, yValue), 20000])
        .range([height_1, 0]);
    svg_bubble.append("g")
        .call(d3.axisLeft(yScale));

    console.log(yScale.domain());
    console.log(yScale.range());

    //bubble size
    const z = d3.scaleLinear()
        .domain([d3.min(data, zValue), d3.max(data, zValue)])
        .range([10, 40]);

    const myColor = d3.scaleOrdinal()
        .domain(["Bubble_1", "Bubble_2", "Bubble_3"])
        .range(["#C69784", "#BCC1D0", "#E7C090", "#C6B6D2", "#B49F96"]);
    //.range(["#f9caca", "#c5d7ea", "#f2c199", "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22"]);

    const tooltip = d3
        .select("#my_dataviz")
        .append("div")
        .attr("class", "tooltip");

    const showTooltip = function (event, d) {
        console.log("event", event.clientX, d3.event);
        tooltip.transition().duration(200);
        const toolTipMessage = `${d.Area}<br/>Hosting Type: ${d.type}<br/>Average Night Booked Per Listing: ${d.average_nights_booked}<br/>Average Income Per Listing: $${d.income}<br/>Price/night: $${d.price}`;
        tooltip
            .style("opacity", "1")
            .html(toolTipMessage)
            .style("left", event.clientX + "px")
            .style("top", event.clientY + "px");
    };
    /* const toolTip = d3.select('body')
        .append('div')
        .attr('id', 'tooltip')
        .attr('style', 'position: absolute; opacity: 0;'); */

    const hideTooltip = function (event, d) {
        tooltip.transition().duration(200).style("opacity", 0);
    };
    //const stroke_Color = d3.scaleOrdinal()
    //.domain(["overall", "short", "long"])
    //.range(["#59377a","#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22"]);

    //const yAxis = d3.axisLeft(yScale);
    //const xAxis = d3.axisBottom(xScale);

    //const g = svg.append('g')
    //.attr("transform", 'translate('+margin_bubble.left+','+margin_bubble.top+')');

    //g.append('g').call(yAxis);
    //g.append('g').call(xAxis).attr("transform", 'translate('+0+','+innerHeight+')');

    svg_bubble.append('g')
        .selectAll('circle')
        .data(data)
        //.enter()
        .join("circle")
        .attr("class", "bubbles")
        //.attr('cx', d => xScale(xValue(d)))
        .attr("cx", function (d) { return xScale(d.average_nights_booked); })
        .attr('cy', d => yScale(yValue(d)))
        .attr('r', d => z(zValue(d)))
        .style("fill", function (d) { return myColor(d.color_bubble); })
        .style("opacity", "0.8")
        .on("mouseover", showTooltip)
        .on("mouseleave", hideTooltip)
    //.append("title")
    //.text(function (d) { return "Area: " + d.Area + "\n" + "Average Night Booked Per Listing: " + d.average_nights_booked + "\n" + "Average Income Per Listing:  $" + d.income })



    svg_bubble.append("rect")
        .attr("x", 180)
        .attr("y", -190)
        .attr("width", 860)
        .attr("height", 70)
        .attr("fill", "none")
        //.attr("fill","none")
        //.attr("fill","#C6B6D2")
        // .attr("opacity", 0.8)
        .attr("stroke", "#484A4F")
        .attr("stroke-width", "1px")

    svg_bubble.append("rect")
        .attr("x", 190)
        .attr("y", -180)
        .attr("width", 840)
        .attr("height", 50)
        .attr("fill", "none")
        //.attr("fill","#C6B6D2")
        //.attr("opacity", 0.8)
        .attr("stroke", "#484A4F")
        .attr("stroke-width", "1px")

    svg_bubble.append("text")
        //.attr("transform", "translate(100,0)")
        .attr("x", 275)
        .attr("y", -150)
        .attr("font-size", "18px")
        .attr("fill", "#484A4F")
        //.attr("text-align", "center")
        .attr("font", "sans-serif")
        .text("What is your best hosting choice? short-term hosting or long-term hosting?")

    svg_bubble.append("text")
        //.attr("transform", "translate(10,0)")
        .attr("x", -45)
        .attr("y", -30)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Average income/listing")

    svg_bubble.append("text")
        //.attr("transform", "translate(10,0)")
        .attr("x", 1020)
        .attr("y", 600)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Average nights booked/listing")

    svg_bubble.append("text")
        .attr("transform", "translate(100,0)")
        .attr("x", 1000)
        .attr("y", 489)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Price: $779")
    svg_bubble.append("text")
        .attr("transform", "translate(100,0)")
        .attr("x", 1000)
        .attr("y", 505)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Price: $400")
    svg_bubble.append("text")
        .attr("transform", "translate(100,0)")
        .attr("x", 1000)
        .attr("y", 520)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Price: $1")


    svg_bubble.append("rect")
        .attr("x", 940)
        .attr("y", 220)
        .attr("width", 230)
        .attr("height", 320)
        .attr("fill", "none")
        .attr("stroke", "#484A4F")
        .attr("stroke-width", "1px")

    svg_bubble.append("text")
        .attr("x", 960)
        .attr("y", 250)
        .attr("font-size", "18px")
        //.style("font-weight", "bold")
        .attr("font", "sans-serif")
        .text("Color: Listing Types")

    svg_bubble.append("text")
        .attr("x", 960)
        .attr("y", 410)
        .attr("font-size", "18px")
        //.style("font-weight", "bold")
        .attr("font", "sans-serif")
        .text("Bubble Size: Price")

    svg_bubble.append("circle")
        .attr("cx", 970)
        .attr("cy", 280)
        .attr("r", 10)
        .attr("fill", "#BCC1D0")
        .attr("stroke", "white")
        .attr("stroke-width", "2px")

    svg_bubble.append("text")

        .attr("x", 990)
        .attr("y", 283)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Short-term Listings")

    svg_bubble.append("circle")
        .attr("cx", 970)
        .attr("cy", 310)
        .attr("r", 10)
        //.attr("fill","#C69784")
        .attr("fill", "#E7C090")
        .attr("stroke", "white")
        .attr("stroke-width", "2px")

    svg_bubble.append("text")

        .attr("x", 990)
        .attr("y", 313)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Long-term Listings")


    svg_bubble.append("circle")
        .attr("cx", 970)
        .attr("cy", 340)
        .attr("r", 10)
        .attr("fill", "#C69784")
        .attr("stroke", "white")
        .attr("stroke-width", "2px")

    svg_bubble.append("text")
        .attr("x", 990)
        .attr("y", 343)
        .attr("font-size", "10px")
        .attr("font", "sans-serif")
        .text("Total Listing")
    /* svg_bubble.append('g')
    .attr("transform", "translate(16,0)")
    .attr("fill", 'red')
    .attr("font-weight", 'bold')
    .attr("text-anchor", "end")
    .attr("font-size", 8)
    .attr("text-align", "center")
    .selectAll('text')
    .data(data)
    .join('text')
        .attr("class", "labels")
        .attr('x', function (d) { return xScale(d.average_nights_booked);})
        .attr('y', d => yScale(yValue(d)))
        .attr('dy', '0.1em')
        .text(function (d) { return d.Area }) */

    //.text(function (d) { return "Area: " + d.Area + "\n" + "Average Night Booked Per Listing: " + d.average_nights_booked + "\n" + "Average Income Per Listing:  $" + d.income })



};



// The scale use for bubble size
const size = d3.scaleSqrt()
    .domain([1, 100])  // What's in the data, let's say it is percentage
    .range([1, 100])  // Size in pixel

// Add legend: circles
const valuesToShow = [5, 15, 25]
//const valueLegend = ["Price: $1", "Price: $400", "Price: $779"]
const xCircle = 1000
const xLabel = 1100
const yCircle = 530

svg_bubble
    .selectAll("legend")
    .data(valuesToShow)
    .join("circle")
    .attr("cx", xCircle)
    .attr("cy", d => yCircle - size(d))
    .attr("r", d => size(d))
    .style("fill", "none")
    .attr("stroke", "black")

// Add legend: segments
svg_bubble
    .selectAll("legend")
    .data(valuesToShow)
    .join("line")
    .attr('x1', d => xCircle + size(d))
    .attr('x2', xLabel)
    .attr('y1', d => yCircle - size(d))
    .attr('y2', d => yCircle - size(d))
    .attr('stroke', 'black')
    .style('stroke-dasharray', ('2,2'))

// Add legend: labels
/* svg_bubble
    .selectAll("legend")
    .data(valueLegend, valuesToShow)
    .join("text")
    .attr('x', xLabel)
    .attr('y', d => yCircle - size(d.valuesToShow))
    .text(d=>d.valueLegend)
    .style("font-size", 10)
    .attr('alignment-baseline', 'middle') */